package w83a.w83aOperacionesPaso.w83aResultados;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesPdf;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aUtilidades;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaDelegConvDetCentroPdfAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {


		Comparator comparador=Collections.reverseOrder();
        
        Map general = (HashMap)contexto.get("w83aMapResultadosBean");
        Map convenios=(TreeMap)general.get("convenios");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        
        Font fonttitulo = FontFactory.getFont("Arial", 12, Font.BOLD);
        Font fontbold = FontFactory.getFont("Arial", 8, Font.BOLD);
		Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);

        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        //String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()); 
        String provincia = usuario.getCodTerritorioDelegacion(); 
      
		Document document = new Document();			

		document = new Document(PageSize.A4.rotate()); //Creo un documento 		
		document.setMargins(30, 30, 80, 40);	
	    
		PdfWriter.getInstance(document, response.getOutputStream());		
		response.setContentType("application/pdf");		
    	response.setHeader("Content-Disposition", "attachment;filename=w83aDelegadosPorConvenioDetalle.pdf;");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        response.setStatus(HttpServletResponse.SC_OK);
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance(document, baos);	
        
        //Evento para cabecera de pgina
		Rectangle rct = new Rectangle(54, 36, 788 , 589);
        writer.setBoxSize("art", rct);
        
        W83aUtilidadesPdf.HeaderFooter event = new W83aUtilidadesPdf.HeaderFooter(idioma, usuario.getCalleListadosFormateada());
        writer.setPageEvent(event);
        
        document.open();      
              
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        Paragraph parrafo;
        PdfPCell cell;
        
        parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.delegadosConvenio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.delegadosConvenio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fonttitulo);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);
        	parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        	document.add(parrafo);
        }
        parrafo=new Paragraph(" ");
        document.add(parrafo);
        
        PdfPTable table=new PdfPTable(6);
        table.setWidthPercentage(100);
        
        float[] columnWidths = {0.15f, 1.40f, 1.60f, 0.15f, 1.40f, 1.60f};

        table.setWidths(columnWidths);
        
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","preaviso.texto.filtro.territorio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","preaviso.texto.filtro.territorio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        cell.setBorder(0);
        table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getDescTerritorio(),fontnormalpeq));
        }
    /*	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.centroTrabajo.sector",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.centroTrabajo.sector",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	 if(StringUtils.isNotEmpty(resultadoBean.getSectorTxt())){
    		 cell = new PdfPCell(new Phrase(resultadoBean.getSectorTxt(),fontnormalpeq));
         }   
    	 else{
    		 cell = new PdfPCell(new Phrase(""));
    	 }
    	 */
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.convenio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.convenio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getConvenioTxt())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getConvenioTxt(),fontnormalpeq));
        }
    	else{
    		cell = new PdfPCell(new Phrase(""));
    	}
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	document.add(table);
    	
    	table=new PdfPTable(6);
        table.setWidthPercentage(100);

        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionDesde",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionDesde",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionDesde(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionHasta",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionHasta",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionHasta(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.fregdefhasta",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.fregdefhasta",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaRegistroDefinitivo(),fontnormalpeq));
        }
    	/*cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.detallecentro",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.detallecentro",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.si",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.si",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	*/
    	document.add(table);
    	
    	parrafo=new Paragraph(" ");
    	document.add(parrafo);     
        
        table=new PdfPTable(10);
        table.setWidthPercentage(100);
        
        int contador=0;
        //vble para saber la fila en la que hay que poner los delegados y electores de cada convenio
        int contadorconvenio=0;
        //vble para saber en qu nmero de convenio voy, para poder hacer salto de pgina
        int numconvenios=0;
        
        Map mapConveniosOrdenado = new TreeMap(convenios);
        Set ref = mapConveniosOrdenado.keySet();
        
        String[]valores;
        String convenio;
        String centro;
        String acta;
        
        int electores=0;
        int numvotos=0;
        
        //Totales convenio
        int totalelectores;
        int totalvotos;
        int totaldelegados;
        List sindicatossector=new ArrayList();
        
        //Totales territorio
        int totalelectoresterrit=0;
        int numvotosterrit=0;
        int totaldelegadosterrit=0;
        List sindicatossectorterrit=new ArrayList();
        boolean poneriniciofila=false;
        boolean nootros=false;
	   for( Iterator it = ref.iterator(); it.hasNext();) {
		    contador=0;
		    contadorconvenio=0;
		    numconvenios=numconvenios+1;
	        totalelectores=0;
	        totalvotos=0;
	        numvotos=0;
	        totaldelegados=0;
	        totalelectores=0;
	        sindicatossector=new ArrayList();//NOPMD
		    convenio=(String)it.next();
        	valores=convenio.split("\\|");
        	//Descripcin convenio
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.preavisos.labels.convenio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.preavisos.labels.convenio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+Integer.parseInt(valores[0])+"-"+valores[1],fontbold);//NOPMD
        	document.add(parrafo);
            
            table=new PdfPTable(10);//NOPMD
            float[] columnTabla = {7f, 2f, 1f, 1f, 1f, 1f, 1f, 1.5f, 1f, 1f};
            table.setWidths(columnTabla);
            table.setWidthPercentage(100);
        	
          	//Fila central sindical...
            contador=contador+1;
        	cell = new PdfPCell(new Phrase(""));//NOPMD
        	cell.setBorder(0);
        	cell.setColspan(6);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralsindical",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralsindical",W83aClsConstantes.CONSTANTE_CASTELLANO),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setColspan(2);
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.menu.Delegados",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.menu.Delegados",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	cell.setColspan(2);
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
           
        	//Fila denominacin convenio...
        	contador=contador+1;
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nombrecentro",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nombrecentro",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));  //NOPMD   	
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	cell.setBackgroundColor(new Color(204,204,204));  //NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.registroDefinitivo.numEntrada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.registroDefinitivo.numEntrada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.elect",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.elect",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.votant",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.votant",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.deleg",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.deleg",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.partic",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.partic",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cod",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cod",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.sindicatos.siglas",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.sindicatos.siglas",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.num",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.num",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase("%",fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	table.addCell(cell);        	
            int numdelegados;
            //Descripcin convenio
            Map mapActasOrdenado = new TreeMap((Map)mapConveniosOrdenado.get(convenio));//NOPMD
            Set refc = mapActasOrdenado.keySet();
        	for(Iterator itconv = refc.iterator(); itconv.hasNext();) {
        		contador=contador+1;
        		contadorconvenio=contador;
        		centro=(String)itconv.next();
        		numdelegados=0;
            	valores=centro.split("\\|");
            	if(StringUtils.isNotEmpty(valores[1])){
            		cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
            		cell.setBorder(0);
             		if (contador==3){
            			cell.setBorder(Rectangle.TOP);
            		}
            	}
            	table.addCell(cell);
            	numdelegados=0;
            	acta=(String)valores[0];
            	String actater="";
            	if (acta.startsWith("1")){
            		actater="0"+acta;
            	}
            	else{
            		actater=acta;
            	}
            	StringBuffer sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
            	String valor=W83aUtilidadesComunes.rellenarCeros(actater.substring(6,12));
            	sb.append(valor);
            	cell = new PdfPCell(new Phrase(Integer.parseInt(actater.substring(0,2))+"/"+actater.substring(2,6)+"/"+sb.toString(),fontnormal));//NOPMD
        		cell.setBorder(0);
        		cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        		table.addCell(cell);
                String datos=(String)((List)mapActasOrdenado.get(centro)).get(((List)mapActasOrdenado.get(centro)).size()-1);
                valores=datos.split("\\|");
                if(StringUtils.isNotEmpty(valores[0])){
                	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
            		cell.setBorder(0);
            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                }
                table.addCell(cell);
                if(StringUtils.isNotEmpty(valores[1])){
                	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(valores[1])),fontnormal));//NOPMD
            		cell.setBorder(0);
            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                }
                table.addCell(cell);
                electores=Integer.parseInt(valores[0]);
                totalelectores=totalelectores+electores;
                totalelectoresterrit=totalelectoresterrit+electores;
                numvotos=Integer.parseInt(valores[1]);
                totalvotos=totalvotos+numvotos;
                numvotosterrit=numvotosterrit+numvotos;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	numdelegados=numdelegados+Integer.parseInt(valores[0]);//
                }
                boolean otros=false;
                poneriniciofila=false;
                int delegados=0;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	if (i!=0&&poneriniciofila){
            			cell = new PdfPCell(new Phrase(""));//NOPMD
            			cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		contador=contador+1;
            		}
                	sindicatossector=W83aUtilidadesComunes.listaSindicatos(sindicatossector, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	sindicatossectorterrit=W83aUtilidadesComunes.listaSindicatos(sindicatossectorterrit, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	//debemos mirar  si el % no supera el que hemos puesto, para ponerlo en otros
                	if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados)*100<porcentajeFiltro.floatValue()){//
                		delegados=delegados+Integer.parseInt(valores[0]);//
                		otros=true;
                		poneriniciofila=false;
                	}
                	else{
                		poneriniciofila=true;
                		cell = new PdfPCell(new Phrase(""));//NOPMD
            			cell.setBorder(0);
            			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                		table.addCell(cell);
                		if ("-1".equals(valores[2])){
                			cell = new PdfPCell(new Phrase(""));//NOPMD
	            			cell.setBorder(0);
	            			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[2])){
	                			cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.numero(valores[2])),fontnormal));//NOPMD
		            			cell.setBorder(0);
		            			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
	                		}
	                	}
                		table.addCell(cell);
                		if ("-1".equals(valores[2])){//
                			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
            				cell.setBorder(0);
	                	}else if ("null".equals(valores[1])){
	                		cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	            			cell.setBorder(0);
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[1])){
	                			cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
		            			cell.setBorder(0);
	                		}
	                	}	
                		table.addCell(cell);
	                    if(StringUtils.isNotEmpty(valores[0])){
	                    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
            				cell.setBorder(0);
            				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	                    }
	                    table.addCell(cell);
	                    totaldelegados=totaldelegados+Integer.parseInt(valores[0]);//
	                    totaldelegadosterrit=totaldelegadosterrit+Integer.parseInt(valores[0]);//
	                    cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),numdelegados),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				if (contador==3){
                			cell.setBorder(Rectangle.TOP);
                		}
        				table.addCell(cell);
                		}
                	}
                    if(otros){
                    	if (poneriniciofila){
                    		contador=contador+1;
                    		cell = new PdfPCell(new Phrase(""));//NOPMD
                    		cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                    	}
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                    	table.addCell(cell);
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                    	cell.setBorder(0);
                    	cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                    	table.addCell(cell);
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                    	cell.setBorder(0);
                    	table.addCell(cell);
                		totaldelegados=totaldelegados+delegados;
                		totaldelegadosterrit=totaldelegadosterrit+delegados;
                		//metemos la linea de otros
                		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));//NOPMD
        				cell.setBorder(0);
        				table.addCell(cell);
        				
        				cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(delegados),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				table.addCell(cell);
        				
        				cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.calcularporcentajePdf(delegados,numdelegados)),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				if (contador==3){
                			cell.setBorder(Rectangle.TOP);
                		}
        				table.addCell(cell);             		
                	}
                    PdfPCell[] cells=(PdfPCell[])table.getRow(contadorconvenio-1).getCells();
                	cells[4].setPhrase(new Phrase(String.valueOf(numdelegados),fontnormal));//NOPMD
                	cells[5].setPhrase(new Phrase(W83aUtilidades.calcularporcentajePdf(numvotos,electores),fontnormal));//NOPMD 	
        	}
        	poneriniciofila=false;
        	nootros=false;
     	    cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalconvenio",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalconvenio",W83aClsConstantes.CONSTANTE_CASTELLANO),fontnormal));//NOPMD
  		    cell.setBorder(0);
  		    cell.setBorder(Rectangle.TOP);
  		    table.addCell(cell);
  		    cell = new PdfPCell(new Phrase(""));//NOPMD
		    cell.setBorder(0);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalelectores),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalvotos),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totaldelegados),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(totalvotos,totalelectores),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
        	boolean otros=false;
        	int delegados=0;
        	Collections.sort(sindicatossector,comparador);//la ordenamos de mayor a menor
        	for (int i=0;i<sindicatossector.size();i++){
        		if (i!=0&&poneriniciofila){
        			cell = new PdfPCell(new Phrase(""));//NOPMD
        			cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
        		}
        		valores=((String)sindicatossector.get(i)).split("\\|");
        		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegados)*100<porcentajeFiltro.floatValue()){//
        			delegados=delegados+Integer.parseInt(valores[0]);//
        			otros=true;
        			poneriniciofila=false;
        		}
        		else{
        			poneriniciofila=true;
        			nootros=true;
	        		if ("-1".equals(valores[2])){//
	        			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	        			cell.setBorder(0);
	        			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[2])){
	        				cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.numero(valores[2])),fontnormal));//NOPMD
		        			cell.setBorder(0);
		        			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
		        			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
	        			}
	        		}
	        		table.addCell(cell);
	            	if ("-1".equals(valores[2])){//
	            		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
	            		cell.setBorder(0);
	            		if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        		}else if ("null".equals(valores[1])){
	        			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	        			cell.setBorder(0);
	        			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[1])){
	        				cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
		        			cell.setBorder(0);
		        			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
	        			}
	        		}
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(valores[0])){
	            		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
	            		cell.setBorder(0);
	            		if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	            	}
	            	table.addCell(cell);
	            	cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),totaldelegados),fontnormal));//NOPMD
	            	cell.setBorder(0);
	            	if (i==0){
        				cell.setBorder(Rectangle.TOP);
        			}
	            	cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	            	table.addCell(cell);
        		}
        	}
        	if(otros){
        		if (poneriniciofila){
        			cell = new PdfPCell(new Phrase(""));//NOPMD
        			cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
        		}
        		//metemos la linea de otros
        		cell = new PdfPCell(new Phrase(""));//NOPMD
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));//NOPMD
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(delegados),fontnormal));//NOPMD
        		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.calcularporcentajePdf(delegados,totaldelegados)),fontnormal));//NOPMD
        		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);		
        	}
        	if (numconvenios!=mapConveniosOrdenado.size()){ 
        		document.add(table);
                document.newPage();
        	}
        }
	   poneriniciofila=false;
	   nootros=false;
	   if (!"".equals(resultadoBean.getDescTerritorio())){
			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalterritorio",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalterritorio",W83aClsConstantes.CONSTANTE_CASTELLANO),fontnormal));
		}
		else{
			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalcomunidad",W83aClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalcomunidad",W83aClsConstantes.CONSTANTE_CASTELLANO),fontnormal));
		}
	   cell.setBorder(0);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(""));
	   cell.setBorder(0);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalelectoresterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numvotosterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totaldelegadosterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(numvotosterrit,totalelectoresterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
       boolean otros=false;
	 	int delegados=0;
	 	Collections.sort(sindicatossectorterrit,comparador);//la ordenamos de mayor a menor
	 	for (int i=0;i<sindicatossectorterrit.size();i++){
		 		if (i!=0&&poneriniciofila){
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);			 		  
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		}
		    		valores=((String)sindicatossectorterrit.get(i)).split("\\|");
		    		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit)*100<porcentajeFiltro.floatValue()){//
		    			delegados=delegados+Integer.parseInt(valores[0]);//
		    			otros=true;
		    			poneriniciofila=false;
		    		}
		    		else{
		    			poneriniciofila=true;
		    			nootros=true;
			    		if ("-1".equals(valores[2])){//
			    			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			    		}
			    		else{
			    			if(StringUtils.isNotEmpty(valores[2])){
			    				cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.numero(valores[2])),fontnormal));//NOPMD
				    			cell.setBorder(0);
				    			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
				    			if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    			}
			    		}
			    		table.addCell(cell);
			        	if ("-1".equals(valores[2])){
			        		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			    		}else if ("null".equals(valores[1])){
			    			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
			    			   cell.setBorder(0);
			    			   if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    		}
			    		else{
			    			if(StringUtils.isNotEmpty(valores[1])){
			    				cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
				    			cell.setBorder(0);
				    			if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    			}
			    		}
			        	table.addCell(cell);
			        	if(StringUtils.isNotEmpty(valores[0])){
			        		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			        	}
			        	table.addCell(cell);
			        	cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),totaldelegadosterrit),fontnormal));//NOPMD
		    			cell.setBorder(0);
		    			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
		    			table.addCell(cell);
		    		}

    	}
	 	if(otros){
	 		if (poneriniciofila){
	 			cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);			 		  
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
	 		}
	 		//metemos la linea de otros
    		cell = new PdfPCell(new Phrase(""));
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(delegados),fontnormal));
    		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(String.valueOf(W83aUtilidades.calcularporcentajePdf(delegados,totaldelegadosterrit)),fontnormal));
    		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);		
    	}
	 	
	    document.add(table);
		document.close();
		
		W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"horizontal");
		
		OutputStream out = response.getOutputStream();	        
        baos.writeTo(out);
        out.flush();			
	    out.close();
		
   	return null;
	}
	
}
